<?php
/**
 * finish.php
 * Endpoint khusus untuk notifikasi "Laundry Selesai"
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// 1. Ambil Data JSON
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!$data || empty($data['phone']) || empty($data['message'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Phone and Message required']);
    exit();
}

// 2. Format Nomor HP (08 -> 628)
$phone = preg_replace('/\D/', '', $data['phone']);
if (substr($phone, 0, 1) === '0') $phone = '62' . substr($phone, 1);
if (substr($phone, 0, 2) !== '62') $phone = '62' . $phone;

// 3. Konfigurasi Wablas
$wablasDomain = 'https://sby.wablas.com';
$wablasToken = 'DdziSjvLXmDwuyr5b0TILf6rTDOaM8glOStpdHps9F1O3j4HT7AC7K0'; 
$wablasSecret = 'cH3GFGjm'; 

// 4. Kirim ke Wablas
$curl = curl_init();
$payload = [
    'data' => [[
        'phone' => $phone,
        'message' => $data['message'],
        'isGroup' => false
    ]]
];

curl_setopt_array($curl, [
    CURLOPT_URL => $wablasDomain . "/api/v2/send-message",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        "Authorization: $wablasToken.$wablasSecret",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

// 5. Response
if ($httpCode == 200) {
    echo $response;
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => "Wablas Error $httpCode"]);
}
?>