<?php
/**
 * Forwarder API sederhana untuk menerima data dari E-STRUK
 * dan meneruskannya ke WhatsApp via Wablas
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Logging function
function logMessage($message) {
    $logFile = __DIR__ . '/qrmember.log';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND | LOCK_EX);
}

// Get request body
$input = file_get_contents('php://input');
$data = json_decode($input, true);

logMessage("Received request: " . $input);

// Validate input
if (!$data) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid JSON data'
    ]);
    logMessage("Error: Invalid JSON data");
    exit();
}

// Required fields (tanpa transaction_id)
$requiredFields = ['phone', 'message'];
foreach ($requiredFields as $field) {
    if (!isset($data[$field]) || empty($data[$field])) {
        http_response_code(400);
        echo json_encode([
            'status' => 'error',
            'message' => "Missing required field: $field"
        ]);
        logMessage("Error: Missing required field: $field");
        exit();
    }
}

try {
    // Extract data
    $phone = $data['phone'];
    $message = $data['message'];
    
    // Format phone number
    $phone = preg_replace('/\D/', '', $phone);
    if (substr($phone, 0, 1) === '0') {
        $phone = '62' . substr($phone, 1);
    }
    if (substr($phone, 0, 2) !== '62') {
        $phone = '62' . $phone;
    }
    
    logMessage("Processing message for phone: $phone");

    // Konfigurasi Wablas
    $wablasDomain = 'https://sby.wablas.com';
    $wablasToken = 'DdziSjvLXmDwuyr5b0TILf6rTDOaM8glOStpdHps9F1O3j4HT7AC7K0';
    $wablasSecret = 'cH3GFGjm';
    
    // Prepare payload for Wablas
    $wablasPayload = [
        'data' => [
            [
                'phone' => $phone,
                'message' => $message,
                'isGroup' => false
            ]
        ]
    ];
    
    // Send to Wablas API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $wablasDomain . '/api/v2/send-message');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($wablasPayload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $wablasToken . '.' . $wablasSecret,
        'User-Agent: E-STRUK-Forwarder/1.0'
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);
    
    logMessage("Wablas API Response - Code: $httpCode, Response: $response");
    
    if ($httpCode !== 200) {
        throw new Exception("Wablas API returned HTTP $httpCode: $response");
    }
    
    $wablasResponse = json_decode($response, true);
    
    // Check if Wablas response indicates success
    if (!isset($wablasResponse['status']) || $wablasResponse['status'] !== true) {
        $errorMsg = $wablasResponse['message'] ?? 'Unknown error from Wablas';
        throw new Exception("Wablas API error: $errorMsg");
    }
    
    // Success response (tanpa transaction_id)
    http_response_code(200);
    echo json_encode([
        'status' => 'success',
        'message' => 'Message sent successfully',
        'phone' => $phone,
        'wablas_response' => $wablasResponse
    ]);
    
    logMessage("Success: Message sent to $phone");
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'phone' => $phone ?? 'unknown'
    ]);
    
    logMessage("Exception: " . $e->getMessage());
}
?>